/*
 * Decompiled with CFR 0.152.
 */
package SysnovaFeed;

import SysnovaFeed.sqlManager;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.gnu.glpk.GLPK;
import org.gnu.glpk.GLPKConstants;
import org.gnu.glpk.GlpkException;
import org.gnu.glpk.SWIGTYPE_p_double;
import org.gnu.glpk.SWIGTYPE_p_int;
import org.gnu.glpk.glp_prob;
import org.gnu.glpk.glp_smcp;

public class Formulation {
    glp_prob lp;
    glp_smcp parm;
    SWIGTYPE_p_int ind;
    SWIGTYPE_p_double val;
    int ret;
    ArrayList ingrediantValueList = new ArrayList();
    ArrayList nutrientValueList = new ArrayList();
    ArrayList constrainList = new ArrayList();

    public boolean calculation(int Compound_id) {
        int i;
        HashMap<Integer, Integer> ingredientMap = new HashMap<Integer, Integer>();
        ingredientMap.clear();
        this.ingrediantValueList.clear();
        this.nutrientValueList.clear();
        this.constrainList.clear();
        boolean status = false;
        try {
            this.ingrediantValueList = sqlManager.getCompoundingredientformulation(Compound_id);
            this.nutrientValueList = sqlManager.getCompoundNutrientformulation(Compound_id);
            for (i = 0; i < this.ingrediantValueList.size(); ++i) {
                Vector tableline1 = (Vector)this.ingrediantValueList.get(i);
                int INGREDIENT_ID = (Integer)tableline1.get(0);
                if (ingredientMap.containsKey(INGREDIENT_ID)) continue;
                ingredientMap.put(INGREDIENT_ID, i + 1);
            }
            this.constrainList = sqlManager.getConstrain(Compound_id, ingredientMap);
        }
        catch (SQLException ex) {
            Logger.getLogger(Formulation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Formulation.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.ingrediantValueList.size() < 1 || this.nutrientValueList.size() < 1 || this.constrainList.size() < 1) {
            JOptionPane.showMessageDialog(null, "Data Not Found", "Error", 0);
        }
        try {
            int j;
            this.lp = GLPK.glp_create_prob();
            GLPK.glp_set_prob_name(this.lp, "LibreFeed");
            this.ind = GLPK.new_intArray(this.ingrediantValueList.size() + 10);
            this.val = GLPK.new_doubleArray(this.ingrediantValueList.size() + 10);
            GLPK.glp_add_cols(this.lp, this.ingrediantValueList.size() + 1);
            for (i = 0; i < this.ingrediantValueList.size(); ++i) {
                Vector ingrediantLine = (Vector)this.ingrediantValueList.get(i);
                int COMPOUNDINGREDIENT_ID = (Integer)ingrediantLine.get(4);
                Double minVal = (Double)ingrediantLine.get(2);
                Double maxVal = (Double)ingrediantLine.get(3);
                GLPK.glp_set_col_name(this.lp, i + 1, "" + COMPOUNDINGREDIENT_ID);
                if (minVal == 0.0 && maxVal == 0.0) {
                    GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                    GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_DB, minVal, maxVal + Formulation.getTotalProduceQty());
                    continue;
                }
                if (minVal > 0.0 && maxVal == 0.0) {
                    GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                    GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_LO, minVal, maxVal + Formulation.getTotalProduceQty());
                    continue;
                }
                if (maxVal - minVal <= 1.0E-8) {
                    GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                    GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_FX, minVal, maxVal);
                    continue;
                }
                if (minVal > 0.0 && maxVal > 0.0) {
                    GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                    GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_DB, minVal, maxVal);
                    continue;
                }
                if (minVal == 0.0 && maxVal > 0.0) {
                    GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                    GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_DB, minVal, maxVal);
                    continue;
                }
                GLPK.glp_set_col_kind(this.lp, i + 1, GLPKConstants.GLP_CV);
                GLPK.glp_set_col_bnds(this.lp, i + 1, GLPKConstants.GLP_DB, minVal, maxVal);
            }
            GLPK.glp_add_rows(this.lp, this.constrainList.size() + 10);
            int coumnNo = 1;
            int rowNo = 1;
            int previousneutaint_ID = -1;
            for (int i2 = 0; i2 < this.constrainList.size(); ++i2) {
                Vector constrainLine = (Vector)this.constrainList.get(i2);
                Double Value = (Double)constrainLine.get(2);
                int ingediant_ID = (Integer)constrainLine.get(3);
                int neutaint_ID = (Integer)constrainLine.get(4);
                int serialNo = (Integer)constrainLine.get(5);
                int COMPOUNDNUTRIENT_ID = (Integer)constrainLine.get(6);
                if (previousneutaint_ID != neutaint_ID) {
                    if (previousneutaint_ID != -1) {
                        GLPK.glp_set_mat_row(this.lp, coumnNo - 1, rowNo - 1, this.ind, this.val);
                    }
                    previousneutaint_ID = neutaint_ID;
                    GLPK.glp_set_row_name(this.lp, coumnNo, "" + COMPOUNDNUTRIENT_ID);
                    boolean isenter = false;
                    for (int j2 = 0; j2 < this.nutrientValueList.size() && !isenter; ++j2) {
                        Vector nutrientLine = (Vector)this.nutrientValueList.get(j2);
                        int nutrient_ID = (Integer)nutrientLine.get(0);
                        Double minVal = (Double)nutrientLine.get(1) * Formulation.getTotalProduceQty();
                        Double maxVal = (Double)nutrientLine.get(2) * Formulation.getTotalProduceQty();
                        if (nutrient_ID != neutaint_ID) continue;
                        if (minVal == 0.0 && maxVal == 0.0) {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_DB, minVal, maxVal + 1.0E8);
                        } else if (minVal > 0.0 && maxVal == 0.0) {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_LO, minVal, 0.0);
                        } else if (maxVal - minVal <= 1.0E-8) {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_FX, minVal, maxVal);
                        } else if (minVal > 0.0 && maxVal > 0.0) {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_DB, minVal, maxVal);
                        } else if (minVal == 0.0 && maxVal > 0.0) {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_DB, 0.0, maxVal);
                        } else {
                            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_DB, minVal, maxVal);
                        }
                        isenter = true;
                    }
                    if (!isenter) {
                        GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_DB, 0.0, 1.0E8);
                    }
                    ++coumnNo;
                    rowNo = 1;
                }
                GLPK.intArray_setitem(this.ind, rowNo, serialNo);
                GLPK.doubleArray_setitem(this.val, rowNo, Value);
                ++rowNo;
            }
            GLPK.glp_set_mat_row(this.lp, coumnNo - 1, rowNo - 1, this.ind, this.val);
            GLPK.glp_set_row_name(this.lp, coumnNo, "0000");
            GLPK.glp_set_row_bnds(this.lp, coumnNo, GLPKConstants.GLP_FX, Formulation.getTotalProduceQty(), Formulation.getTotalProduceQty());
            for (j = 0; j < this.ingrediantValueList.size(); ++j) {
                GLPK.intArray_setitem(this.ind, j + 1, j + 1);
                GLPK.doubleArray_setitem(this.val, j + 1, 1.0);
            }
            GLPK.glp_set_mat_row(this.lp, coumnNo, this.ingrediantValueList.size(), this.ind, this.val);
            GLPK.delete_intArray(this.ind);
            GLPK.delete_doubleArray(this.val);
            GLPK.glp_set_obj_name(this.lp, "cost");
            GLPK.glp_set_obj_dir(this.lp, GLPKConstants.GLP_MIN);
            for (j = 0; j < this.ingrediantValueList.size(); ++j) {
                Vector ingrediantPriceLine = (Vector)this.ingrediantValueList.get(j);
                Double value = (Double)ingrediantPriceLine.get(1);
                GLPK.glp_set_obj_coef(this.lp, j + 1, value);
            }
            this.parm = new glp_smcp();
            GLPK.glp_init_smcp(this.parm);
            this.ret = GLPK.glp_simplex(this.lp, this.parm);
            if (this.ret == 0) {
                status = sqlManager.write_lp_solution(this.lp, Compound_id);
            } else {
                JOptionPane.showMessageDialog(null, "The problem could not be solved", "Formulation Error", 0);
            }
            GLPK.glp_delete_prob(this.lp);
        }
        catch (GlpkException ex) {
            this.ret = 1;
            JOptionPane.showMessageDialog(null, "Solution Error. \n" + ex.getMessage(), "GlpkException Error", 0);
            GLPK.glp_delete_prob(this.lp);
        }
        catch (SQLException ex) {
            Logger.getLogger(Formulation.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, "Solution Error. \n" + ex.getMessage(), "SQLException Error", 0);
            GLPK.glp_delete_prob(this.lp);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Formulation.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, "Solution Error. \n" + ex.getMessage(), "UnknownHostException Error", 0);
            GLPK.glp_delete_prob(this.lp);
        }
        return status;
    }

    static void write_lp_solution(glp_prob lp) {
        int i;
        String name = GLPK.glp_get_obj_name(lp);
        double val = GLPK.glp_get_obj_val(lp);
        System.out.print(name);
        System.out.print(" For Per Kg = ");
        System.out.println(val / Formulation.getTotalProduceQty());
        int c = GLPK.glp_get_num_rows(lp);
        int n = GLPK.glp_get_num_cols(lp);
        for (i = 1; i <= n; ++i) {
            name = GLPK.glp_get_col_name(lp, i);
            if (name == null) continue;
            val = GLPK.glp_get_col_prim(lp, i);
            System.out.print(name);
            System.out.print(" = ");
            System.out.println(val);
        }
        System.out.println("");
        System.out.println(" ==========================");
        System.out.println("  ");
        for (i = 1; i <= c; ++i) {
            name = GLPK.glp_get_row_name(lp, i);
            double lo = GLPK.glp_get_row_lb(lp, i);
            double prim = GLPK.glp_get_row_prim(lp, i);
            double ub = GLPK.glp_get_row_ub(lp, i);
            if (name == null) continue;
            if (name.endsWith("Demand")) {
                System.out.println(" ==========================");
                System.out.println(" ==========================");
                System.out.print("Total Produce In Kg");
                System.out.print(" = ");
                System.out.println(" value: " + prim);
                continue;
            }
            System.out.print(name);
            System.out.print(" = ");
            System.out.println(" value: " + prim / Formulation.getTotalProduceQty());
        }
        name = GLPK.glp_get_obj_name(lp);
        val = GLPK.glp_get_obj_val(lp);
        System.out.print(name);
        System.out.print(" For Per Kg = ");
        System.out.println(val / Formulation.getTotalProduceQty());
    }

    public static double getTotalProduceQty() {
        double produce_Total_Compound = 100.0;
        return produce_Total_Compound;
    }
}

