/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import org.apache.commons.collections.ReferenceMap;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxenXPathExecuter
implements JRXPathExecuter {
    private final Map<String, XPath> cachedXPaths = new ReferenceMap();

    protected XPath getXPath(String expression) throws JRException {
        XPath xPath = this.cachedXPaths.get(expression);
        if (xPath == null) {
            try {
                xPath = new DOMXPath(expression);
            }
            catch (JaxenException e) {
                throw new JRException("XPath compilation failed. Expression: " + expression, e);
            }
            this.cachedXPaths.put(expression, xPath);
        }
        return xPath;
    }

    public NodeList selectNodeList(Node contextNode, String expression) throws JRException {
        try {
            ArrayList<Object> nodes;
            XPath xpath = this.getXPath(expression);
            Object object = xpath.evaluate((Object)contextNode);
            if (object instanceof List) {
                nodes = (ArrayList<Object>)object;
            } else {
                nodes = new ArrayList<Object>();
                nodes.add(object);
            }
            return new NodeListWrapper(nodes);
        }
        catch (JaxenException e) {
            throw new JRException("XPath selection failed. Expression: " + expression, e);
        }
    }

    public Object selectObject(Node contextNode, String expression) throws JRException {
        try {
            List list;
            DOMXPath xpath = new DOMXPath(expression);
            Object object = xpath.evaluate((Object)contextNode);
            Object value = object instanceof List ? ((list = (List)object).isEmpty() ? null : list.get(0)) : (object instanceof Number || object instanceof Boolean ? object : object.toString());
            return value;
        }
        catch (JaxenException e) {
            throw new JRException("XPath selection failed. Expression: " + expression, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class NodeListWrapper
    implements NodeList {
        private final List<?> nodes;

        public NodeListWrapper(List<?> nodes) {
            this.nodes = nodes;
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        @Override
        public Node item(int index) {
            return (Node)this.nodes.get(index);
        }
    }
}

