/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.Win32PrintService;
import sun.security.action.GetPropertyAction;

public class Win32PrintServiceLookup
extends PrintServiceLookup {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private String[] printers;
    private PrintService[] printServices;
    private static Win32PrintServiceLookup win32PrintLUS;

    public static Win32PrintServiceLookup getWin32PrintLUS() {
        if (win32PrintLUS == null) {
            PrintServiceLookup.lookupDefaultPrintService();
        }
        return win32PrintLUS;
    }

    public Win32PrintServiceLookup() {
        if (win32PrintLUS == null) {
            win32PrintLUS = this;
            String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osName != null && osName.startsWith("Windows 98")) {
                return;
            }
            PrinterChangeListener thr = new PrinterChangeListener();
            thr.setDaemon(true);
            thr.start();
        }
    }

    @Override
    public synchronized PrintService[] getPrintServices() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            this.refreshServices();
        }
        return this.printServices;
    }

    private synchronized void refreshServices() {
        this.printers = this.getAllPrinterNames();
        if (this.printers == null) {
            this.printServices = new PrintService[0];
            return;
        }
        PrintService[] newServices = new PrintService[this.printers.length];
        PrintService defService = this.getDefaultPrintService();
        for (int p = 0; p < this.printers.length; ++p) {
            int j;
            if (defService != null && this.printers[p].equals(defService.getName())) {
                newServices[p] = defService;
                continue;
            }
            if (this.printServices == null) {
                newServices[p] = new Win32PrintService(this.printers[p]);
                continue;
            }
            for (j = 0; j < this.printServices.length; ++j) {
                if (this.printServices[j] == null || !this.printers[p].equals(this.printServices[j].getName())) continue;
                newServices[p] = this.printServices[j];
                this.printServices[j] = null;
                break;
            }
            if (j != this.printServices.length) continue;
            newServices[p] = new Win32PrintService(this.printers[p]);
        }
        if (this.printServices != null) {
            for (int j = 0; j < this.printServices.length; ++j) {
                if (!(this.printServices[j] instanceof Win32PrintService) || this.printServices[j].equals(this.defaultPrintService)) continue;
                ((Win32PrintService)this.printServices[j]).invalidateService();
            }
        }
        this.printServices = newServices;
    }

    public synchronized PrintService getPrintServiceByName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        PrintService[] printServices = this.getPrintServices();
        for (int i = 0; i < printServices.length; ++i) {
            if (!printServices[i].getName().equals(name)) continue;
            return printServices[i];
        }
        return null;
    }

    boolean matchingService(PrintService service, PrintServiceAttributeSet serviceSet) {
        if (serviceSet != null) {
            Attribute[] attrs = serviceSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                Attribute serviceAttr = service.getAttribute(attrs[i].getCategory());
                if (serviceAttr != null && serviceAttr.equals(attrs[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
        PrinterName name;
        PrintService service;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet requestSet = null;
        AttributeSet serviceSet = null;
        if (attributes != null && !attributes.isEmpty()) {
            requestSet = new HashPrintRequestAttributeSet();
            serviceSet = new HashPrintServiceAttributeSet();
            Attribute[] attrs = attributes.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] instanceof PrintRequestAttribute) {
                    requestSet.add(attrs[i]);
                    continue;
                }
                if (!(attrs[i] instanceof PrintServiceAttribute)) continue;
                serviceSet.add(attrs[i]);
            }
        }
        PrintService[] services = null;
        services = serviceSet != null && serviceSet.get(PrinterName.class) != null ? ((service = this.getPrintServiceByName((name = (PrinterName)serviceSet.get(PrinterName.class)).getValue())) == null || !this.matchingService(service, (PrintServiceAttributeSet)serviceSet) ? new PrintService[]{} : new PrintService[]{service}) : this.getPrintServices();
        if (services.length == 0) {
            return services;
        }
        ArrayList<PrintService> matchingServices = new ArrayList<PrintService>();
        for (int i = 0; i < services.length; ++i) {
            try {
                if (services[i].getUnsupportedAttributes(flavor, requestSet) != null) continue;
                matchingServices.add(services[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        services = new PrintService[matchingServices.size()];
        return matchingServices.toArray(services);
    }

    @Override
    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    @Override
    public synchronized PrintService getDefaultPrintService() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        this.defaultPrinter = this.getDefaultPrinterName();
        if (this.defaultPrinter == null) {
            return null;
        }
        if (this.defaultPrintService != null && this.defaultPrintService.getName().equals(this.defaultPrinter)) {
            return this.defaultPrintService;
        }
        this.defaultPrintService = null;
        if (this.printServices != null) {
            for (int j = 0; j < this.printServices.length; ++j) {
                if (!this.defaultPrinter.equals(this.printServices[j].getName())) continue;
                this.defaultPrintService = this.printServices[j];
                break;
            }
        }
        if (this.defaultPrintService == null) {
            this.defaultPrintService = new Win32PrintService(this.defaultPrinter);
        }
        return this.defaultPrintService;
    }

    private native String getDefaultPrinterName();

    private native String[] getAllPrinterNames();

    private native long notifyFirstPrinterChange(String var1);

    private native void notifyClosePrinterChange(long var1);

    private native int notifyPrinterChange(long var1);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
    }

    class PrinterChangeListener
    extends Thread {
        long chgObj;

        PrinterChangeListener() {
            this.chgObj = Win32PrintServiceLookup.this.notifyFirstPrinterChange(null);
        }

        @Override
        public void run() {
            block3: {
                if (this.chgObj == -1L) break block3;
                while (Win32PrintServiceLookup.this.notifyPrinterChange(this.chgObj) != 0) {
                    try {
                        Win32PrintServiceLookup.this.refreshServices();
                    }
                    catch (SecurityException se) {
                        break block3;
                    }
                }
                Win32PrintServiceLookup.this.notifyClosePrinterChange(this.chgObj);
            }
        }
    }
}

