/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Cloneable {
    static final long serialVersionUID = 4433990064191844427L;
    static final MBeanConstructorInfo[] NO_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private final transient boolean arrayGettersSafe;
    private final MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String description, Constructor<?> constructor) {
        this(constructor.getName(), description, MBeanConstructorInfo.constructorSignature(constructor), Introspector.descriptorForElement(constructor));
    }

    public MBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature) {
        this(name, description, signature, null);
    }

    public MBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature, Descriptor descriptor) {
        super(name, description, descriptor);
        signature = signature == null || signature.length == 0 ? MBeanParameterInfo.NO_PARAMS : (MBeanParameterInfo[])signature.clone();
        this.signature = signature;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanConstructorInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature.length == 0) {
            return this.signature;
        }
        return (MBeanParameterInfo[])this.signature.clone();
    }

    private MBeanParameterInfo[] fastGetSignature() {
        if (this.arrayGettersSafe) {
            return this.signature;
        }
        return this.getSignature();
    }

    public String toString() {
        return this.getClass().getName() + "[description=" + this.getDescription() + ", name=" + this.getName() + ", signature=" + Arrays.asList(this.fastGetSignature()) + ", descriptor=" + this.getDescriptor() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MBeanConstructorInfo)) {
            return false;
        }
        MBeanConstructorInfo p = (MBeanConstructorInfo)o;
        return Objects.equals(p.getName(), this.getName()) && Objects.equals(p.getDescription(), this.getDescription()) && Arrays.equals(p.fastGetSignature(), this.fastGetSignature()) && Objects.equals(p.getDescriptor(), this.getDescriptor());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName()) ^ Arrays.hashCode(this.fastGetSignature());
    }

    private static MBeanParameterInfo[] constructorSignature(Constructor<?> cn) {
        Class<?>[] classes = cn.getParameterTypes();
        Annotation[][] annots = cn.getParameterAnnotations();
        return MBeanOperationInfo.parameters(classes, annots);
    }
}

