/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

public final class Method
extends Executable {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    @Override
    MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault) {
        this.clazz = declaringClass;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.exceptionTypes = checkedExceptions;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.annotationDefault = annotationDefault;
    }

    Method copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Method");
        }
        Method res = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        res.root = this;
        res.methodAccessor = this.methodAccessor;
        return res;
    }

    @Override
    Executable getRoot() {
        return this.root;
    }

    @Override
    boolean hasGenericInformation() {
        return this.getGenericSignature() != null;
    }

    @Override
    byte[] getAnnotationBytes() {
        return this.annotations;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return super.getGenericParameterTypes();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return super.getGenericExceptionTypes();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Method) {
            Method other = (Method)obj;
            if (this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName()) {
                if (!this.returnType.equals(other.getReturnType())) {
                    return false;
                }
                return this.equalParamTypes(this.parameterTypes, other.parameterTypes);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return this.sharedToString(Modifier.methodModifiers(), this.isDefault(), this.parameterTypes, this.exceptionTypes);
    }

    @Override
    void specificToStringHeader(StringBuilder sb) {
        sb.append(this.getReturnType().getTypeName()).append(' ');
        sb.append(this.getDeclaringClass().getTypeName()).append('.');
        sb.append(this.getName());
    }

    @Override
    public String toGenericString() {
        return this.sharedToGenericString(Modifier.methodModifiers(), this.isDefault());
    }

    @Override
    void specificToGenericStringHeader(StringBuilder sb) {
        Type genRetType = this.getGenericReturnType();
        sb.append(genRetType.getTypeName()).append(' ');
        sb.append(this.getDeclaringClass().getTypeName()).append('.');
        sb.append(this.getName());
    }

    @CallerSensitive
    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        MethodAccessor ma;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, this.clazz, obj, this.modifiers);
        }
        if ((ma = this.methodAccessor) == null) {
            ma = this.acquireMethodAccessor();
        }
        return ma.invoke(obj, args);
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public boolean isVarArgs() {
        return super.isVarArgs();
    }

    @Override
    public boolean isSynthetic() {
        return super.isSynthetic();
    }

    public boolean isDefault() {
        return (this.getModifiers() & 0x409) == 1 && this.getDeclaringClass().isInterface();
    }

    private MethodAccessor acquireMethodAccessor() {
        MethodAccessor tmp = null;
        if (this.root != null) {
            tmp = this.root.getMethodAccessor();
        }
        if (tmp != null) {
            this.methodAccessor = tmp;
        } else {
            tmp = reflectionFactory.newMethodAccessor(this);
            this.setMethodAccessor(tmp);
        }
        return tmp;
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor accessor) {
        this.methodAccessor = accessor;
        if (this.root != null) {
            this.root.setMethodAccessor(accessor);
        }
    }

    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class<?> memberType = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object result = AnnotationParser.parseMemberValue(memberType, ByteBuffer.wrap(this.annotationDefault), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (result instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return result;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return super.getDeclaredAnnotations();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Override
    public AnnotatedType getAnnotatedReturnType() {
        return this.getAnnotatedReturnType0(this.getGenericReturnType());
    }

    @Override
    void handleParameterNumberMismatch(int resultLength, int numParameters) {
        throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
    }
}

