/*
 * Decompiled with CFR 0.152.
 */
package SysnovaFeed;

import SysnovaFeed.Nutrient;
import SysnovaFeed.sqlManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class IngredientDetails
extends JFrame {
    boolean isNew = false;
    int Ingredient_ID = 0;
    ArrayList tableListData = new ArrayList();
    ArrayList groupList = new ArrayList();
    ArrayList typeList = new ArrayList();
    ArrayList nutrientListData = new ArrayList();
    private JButton backbtn;
    private JTextField codeTextField;
    private JComboBox groupComboBox;
    private JButton homeBtn;
    private JCheckBox isActiveCheckBox;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField nameTextField;
    private JButton newBtn;
    private JButton saveallbtn;
    private JButton savebtn;
    private JTextField scintiTextField;
    private JComboBox typeComboBox;
    private JLabel userNameLabel;

    public IngredientDetails(int row, ArrayList tableList) {
        this.tableListData.clear();
        if (row < 0 || tableList.size() < 1) {
            try {
                this.tableListData.clear();
                this.tableListData = sqlManager.getIngrediantdata();
            }
            catch (SQLException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.tableListData = tableList;
        }
        this.isNew = false;
        this.Ingredient_ID = 0;
        this.initComponents();
        this.userNameLabel.setText("");
        this.userNameLabel.setText(" " + sqlManager.getUserName());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icon.png")));
        this.IngredientDetailsWork();
        if (row > -1) {
            Vector tableline = (Vector)tableList.get(row);
            this.IngredientDataLoad(tableline);
            this.setNeutraintdata();
            this.savebtn.setText("Update");
        } else {
            this.isNew = true;
            this.newBtn.setEnabled(false);
            this.savebtn.setText("Save");
        }
    }

    public void IngredientDataLoad(Vector tableline) {
        Vector line;
        int i;
        String cod = (String)tableline.get(0);
        String nam = (String)tableline.get(1);
        String scienttxt = (String)tableline.get(2);
        String groupval = (String)tableline.get(3);
        int groupid = (Integer)tableline.get(4);
        String typeVal = (String)tableline.get(5);
        int typeid = (Integer)tableline.get(6);
        Boolean isact = (Boolean)tableline.get(7);
        this.Ingredient_ID = (Integer)tableline.get(10);
        for (i = 0; i < this.groupList.size(); ++i) {
            line = (Vector)this.groupList.get(i);
            int Group_ID = (Integer)line.get(0);
            if (groupid != Group_ID) continue;
            this.groupComboBox.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.typeList.size(); ++i) {
            line = (Vector)this.typeList.get(i);
            int typeID = (Integer)line.get(0);
            if (typeid != typeID) continue;
            this.typeComboBox.setSelectedIndex(i + 1);
        }
        this.codeTextField.setText("" + cod);
        this.nameTextField.setText("" + nam);
        this.scintiTextField.setText("" + scienttxt);
        this.isActiveCheckBox.setSelected(isact);
    }

    public void IngredientDetailsWork() {
        this.groupList.clear();
        this.typeList.clear();
        try {
            this.groupList = sqlManager.getIngredientGroupComboodata();
            this.groupComboPanel(this.groupList);
            this.typeList = sqlManager.getIngredienttypeComboodata();
            this.typeComboPanel(this.typeList);
        }
        catch (SQLException ex) {
            Logger.getLogger(Nutrient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Nutrient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setNeutraintdata() {
        try {
            this.nutrientListData = sqlManager.getplantwisenutraintdata(this.Ingredient_ID);
            DefaultTableModel model1 = (DefaultTableModel)this.jTable1.getModel();
            model1.setRowCount(this.nutrientListData.size());
            DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
            rightRenderer.setHorizontalAlignment(4);
            this.jTable1.getColumnModel().getColumn(7).setCellRenderer(rightRenderer);
            this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new CustomCellRenderer());
            this.jTable1.getColumnModel().getColumn(1).setCellRenderer(new CustomCellRenderer());
            this.jTable1.getColumnModel().getColumn(2).setCellRenderer(new CustomCellRenderer());
            this.jTable1.getColumnModel().getColumn(3).setCellRenderer(new CustomCellRenderer());
            this.jTable1.getColumnModel().getColumn(7).setCellRenderer(new CustomCellRenderer());
            for (int i = 0; i < this.nutrientListData.size(); ++i) {
                Vector tableline = (Vector)this.nutrientListData.get(i);
                String cod = (String)tableline.get(2);
                model1.setValueAt(cod, i, 0);
                String nam = (String)tableline.get(3);
                model1.setValueAt(nam, i, 1);
                String longnametxt = (String)tableline.get(4);
                model1.setValueAt(longnametxt, i, 2);
                String groupval = (String)tableline.get(9);
                model1.setValueAt(groupval, i, 3);
                Double specification = (Double)tableline.get(6);
                if (specification != -1.0) {
                    model1.setValueAt(specification, i, 4);
                } else {
                    model1.setValueAt(null, i, 4);
                }
                Double overlay = (Double)tableline.get(7);
                if (overlay != -1.0) {
                    model1.setValueAt(overlay, i, 5);
                } else {
                    model1.setValueAt(null, i, 5);
                }
                Double analysis = (Double)tableline.get(8);
                if (analysis != -1.0) {
                    model1.setValueAt(analysis, i, 6);
                } else {
                    model1.setValueAt(null, i, 6);
                }
                String unit = (String)tableline.get(10);
                model1.setValueAt(unit, i, 7);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Nutrient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Nutrient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void typeComboPanel(ArrayList typeList) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.typeComboBox.getModel();
        model.removeAllElements();
        model.addElement(null);
        for (int i = 0; i < typeList.size(); ++i) {
            Vector line = (Vector)typeList.get(i);
            String name = (String)line.get(1);
            model.addElement(name);
        }
        this.typeComboBox.setModel(model);
    }

    public void groupComboPanel(ArrayList groupList) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.groupComboBox.getModel();
        model.removeAllElements();
        for (int i = 0; i < groupList.size(); ++i) {
            Vector line = (Vector)groupList.get(i);
            int Group_ID = (Integer)line.get(0);
            String name = (String)line.get(1);
            model.addElement(name);
        }
        this.groupComboBox.setModel(model);
    }

    public void saveIngredientData() {
        String code = this.codeTextField.getText();
        if (code.length() < 1) {
            JOptionPane.showMessageDialog(null, "Provide Code", "Code Error", 0);
            return;
        }
        String name = this.nameTextField.getText();
        if (name.length() < 1) {
            JOptionPane.showMessageDialog(null, "Provide Long Name", "Name Error", 0);
            return;
        }
        if (this.tableListData.size() > 0) {
            for (int i = 0; i < this.tableListData.size(); ++i) {
                Vector tableline = (Vector)this.tableListData.get(i);
                int ingredient_ID = (Integer)tableline.get(10);
                if (ingredient_ID == this.Ingredient_ID) continue;
                String cod = (String)tableline.get(0);
                if (code.compareTo(cod) == 0) {
                    JOptionPane.showMessageDialog(null, "Code Already Exits", "Code Error", 0);
                    return;
                }
                String nam = (String)tableline.get(1);
                if (nam.compareTo(name) != 0) continue;
                JOptionPane.showMessageDialog(null, "Short Name Already Exits", "Name Error", 0);
                return;
            }
        }
        String scintiText = this.scintiTextField.getText();
        String groupValue = this.groupComboBox.getSelectedItem().toString();
        int group_Index = this.groupComboBox.getSelectedIndex();
        Vector group = (Vector)this.groupList.get(group_Index);
        int group_ID = (Integer)group.get(0);
        int type_ID = 0;
        int type_Index = this.typeComboBox.getSelectedIndex();
        if (type_Index > 0) {
            Vector type = (Vector)this.typeList.get(type_Index - 1);
            type_ID = (Integer)type.get(0);
        }
        boolean isActiveCheck = this.isActiveCheckBox.isSelected();
        if (this.isNew) {
            try {
                this.Ingredient_ID = sqlManager.saveingredientdata(this.isNew, code, name, scintiText, group_ID, type_ID, isActiveCheck, 0);
                if (this.Ingredient_ID > 0) {
                    this.newBtn.setEnabled(true);
                    this.setNeutraintdata();
                    this.savebtn.setText("Update");
                    JOptionPane.showMessageDialog(null, "Save Successfully", "Save Successfully", 1);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                this.Ingredient_ID = sqlManager.saveingredientdata(this.isNew, code, name, scintiText, group_ID, type_ID, isActiveCheck, this.Ingredient_ID);
                if (this.Ingredient_ID > 0) {
                    this.newBtn.setEnabled(true);
                    JOptionPane.showMessageDialog(null, "Updated Successfully", "Save Successfully", 1);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.userNameLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.codeTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.newBtn = new JButton();
        this.groupComboBox = new JComboBox();
        this.typeComboBox = new JComboBox();
        this.nameTextField = new JTextField();
        this.isActiveCheckBox = new JCheckBox();
        this.scintiTextField = new JTextField();
        this.jLabel10 = new JLabel();
        this.savebtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.homeBtn = new JButton();
        this.saveallbtn = new JButton();
        this.backbtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("SysnovaFEED");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setForeground(new Color(254, 254, 254));
        this.jPanel1.setNextFocusableComponent(this.codeTextField);
        this.jPanel1.setPreferredSize(new Dimension(900, 470));
        this.jPanel2.setBackground(new Color(57, 63, 63));
        this.jPanel2.setNextFocusableComponent(this.codeTextField);
        this.userNameLabel.setFont(new Font("DejaVu Sans", 1, 13));
        this.userNameLabel.setForeground(new Color(232, 245, 245));
        this.userNameLabel.setIcon(new ImageIcon(this.getClass().getResource("/View/profile.png")));
        this.userNameLabel.setText("   ");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.userNameLabel).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userNameLabel));
        this.jLabel3.setFont(new Font("Dialog", 1, 24));
        this.jLabel3.setText("Ingredient Information");
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setNextFocusableComponent(this.codeTextField);
        this.jPanel3.setPreferredSize(new Dimension(700, 350));
        this.codeTextField.setNextFocusableComponent(this.nameTextField);
        this.codeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.codeTextFieldActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Code");
        this.jLabel7.setText("Long Name");
        this.jLabel8.setText("Scientific Name");
        this.jLabel9.setText("Group");
        this.newBtn.setBackground(new Color(182, 141, 142));
        this.newBtn.setFont(new Font("DejaVu Sans", 1, 13));
        this.newBtn.setForeground(new Color(255, 255, 255));
        this.newBtn.setText("New");
        this.newBtn.setCursor(new Cursor(12));
        this.newBtn.setIconTextGap(5);
        this.newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.newBtnActionPerformed(evt);
            }
        });
        this.groupComboBox.setBackground(new Color(255, 255, 255));
        this.typeComboBox.setBackground(new Color(255, 255, 255));
        this.typeComboBox.setForeground(new Color(12, 22, 22));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.nameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.nameTextFieldActionPerformed(evt);
            }
        });
        this.isActiveCheckBox.setSelected(true);
        this.isActiveCheckBox.setText("IsActive");
        this.isActiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.isActiveCheckBoxActionPerformed(evt);
            }
        });
        this.scintiTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.scintiTextFieldActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Type");
        this.savebtn.setBackground(new Color(182, 141, 142));
        this.savebtn.setFont(new Font("DejaVu Sans", 1, 13));
        this.savebtn.setForeground(new Color(255, 255, 255));
        this.savebtn.setText("Save");
        this.savebtn.setCursor(new Cursor(12));
        this.savebtn.setIconTextGap(5);
        this.savebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.savebtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -2, 95, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 39, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.groupComboBox, -2, 196, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.codeTextField, -2, 197, -2))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField, GroupLayout.Alignment.TRAILING, -2, 191, -2).addComponent(this.typeComboBox, GroupLayout.Alignment.TRAILING, -2, 191, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel8).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isActiveCheckBox).addComponent(this.scintiTextField, -2, 207, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.newBtn, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savebtn, -2, 96, -2).addGap(4, 4, 4))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeTextField, -2, 29, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.nameTextField, -2, 29, -2).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.scintiTextField, -2, 29, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupComboBox, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.typeComboBox, -2, -1, -2).addComponent(this.jLabel10)).addComponent(this.isActiveCheckBox)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newBtn).addComponent(this.savebtn)).addGap(63, 63, 63)));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}}, new String[]{"Code", "Nutrient", "Long Name", "Group", "Specification", "Overlay", "Analysis", "Unit"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, Double.class, Double.class, Double.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, true, true, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setColumnSelectionAllowed(true);
        this.jTable1.setGridColor(new Color(241, 227, 227));
        this.jTable1.setRowHeight(20);
        this.jTable1.setSelectionBackground(new Color(213, 237, 239));
        this.jTable1.setSelectionMode(0);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IngredientDetails.this.jTable1MouseClicked(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                IngredientDetails.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.jTable1.getColumnModel().getColumnCount() > 0) {
            this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(150);
            this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(120);
            this.jTable1.getColumnModel().getColumn(1).setMaxWidth(200);
            this.jTable1.getColumnModel().getColumn(4).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(4).setMaxWidth(300);
            this.jTable1.getColumnModel().getColumn(5).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(5).setMaxWidth(300);
            this.jTable1.getColumnModel().getColumn(6).setPreferredWidth(100);
            this.jTable1.getColumnModel().getColumn(6).setMaxWidth(300);
            this.jTable1.getColumnModel().getColumn(7).setMinWidth(60);
            this.jTable1.getColumnModel().getColumn(7).setPreferredWidth(60);
            this.jTable1.getColumnModel().getColumn(7).setMaxWidth(60);
        }
        this.jPanel5.setBackground(new Color(70, 73, 85));
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("Nutrient Data (Analysis Per Kg)");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, 401, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 29, -2));
        this.homeBtn.setBackground(new Color(255, 255, 255));
        this.homeBtn.setFont(new Font("DejaVu Sans", 1, 13));
        this.homeBtn.setForeground(new Color(255, 255, 255));
        this.homeBtn.setIcon(new ImageIcon(this.getClass().getResource("/View/copy_2-32.png")));
        this.homeBtn.setToolTipText("Copy Nutraint Data From Another Ingredients");
        this.homeBtn.setCursor(new Cursor(12));
        this.homeBtn.setIconTextGap(5);
        this.homeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.homeBtnActionPerformed(evt);
            }
        });
        this.saveallbtn.setBackground(new Color(255, 255, 255));
        this.saveallbtn.setFont(new Font("DejaVu Sans", 1, 13));
        this.saveallbtn.setForeground(new Color(255, 255, 255));
        this.saveallbtn.setIcon(new ImageIcon(this.getClass().getResource("/View/savecolor.png")));
        this.saveallbtn.setToolTipText("Save All");
        this.saveallbtn.setCursor(new Cursor(12));
        this.saveallbtn.setIconTextGap(5);
        this.saveallbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.saveallbtnActionPerformed(evt);
            }
        });
        this.backbtn.setBackground(new Color(255, 255, 255));
        this.backbtn.setFont(new Font("DejaVu Sans", 1, 13));
        this.backbtn.setForeground(new Color(255, 255, 255));
        this.backbtn.setIcon(new ImageIcon(this.getClass().getResource("/View/back.png")));
        this.backbtn.setToolTipText("Save All");
        this.backbtn.setCursor(new Cursor(12));
        this.backbtn.setIconTextGap(5);
        this.backbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IngredientDetails.this.backbtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, 930, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.backbtn, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homeBtn, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveallbtn, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, -2, 39, -2).addComponent(this.homeBtn, -2, 44, -2).addComponent(this.saveallbtn, -2, 44, -2).addComponent(this.backbtn, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 388, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 950, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 650, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void newBtnActionPerformed(ActionEvent evt) {
        this.dispose();
        IngredientDetails ingredientDetails = new IngredientDetails(-1, this.tableListData);
        ingredientDetails.setVisible(true);
        this.savebtn.setText("Save");
    }

    private void codeTextFieldActionPerformed(ActionEvent evt) {
    }

    private void scintiTextFieldActionPerformed(ActionEvent evt) {
    }

    private void nameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
    }

    private void homeBtnActionPerformed(ActionEvent evt) {
    }

    private void saveallbtnActionPerformed(ActionEvent evt) {
        if (this.Ingredient_ID < 1) {
            JOptionPane.showMessageDialog(null, "Nutrient not saved.", "Error", 1);
            return;
        }
        DefaultTableModel model1 = (DefaultTableModel)this.jTable1.getModel();
        TableCellEditor editor = this.jTable1.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
            editor.cancelCellEditing();
        }
        for (int i = 0; i < this.nutrientListData.size(); ++i) {
            Vector tableline = (Vector)this.nutrientListData.get(i);
            Double specification = (Double)model1.getValueAt(i, 4);
            tableline.set(6, specification);
            Double overlay = (Double)model1.getValueAt(i, 5);
            tableline.set(7, overlay);
            if (overlay == null) {
                if (specification != null) {
                    tableline.set(8, specification);
                    continue;
                }
                tableline.set(8, -1.0);
                continue;
            }
            tableline.set(8, overlay);
        }
        try {
            boolean isSuccess = sqlManager.saveplantwisenutraintdata(this.nutrientListData, this.Ingredient_ID);
            if (isSuccess) {
                this.setNeutraintdata();
                JOptionPane.showMessageDialog(null, "Saved Successfully", "Save Successfully", 1);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(IngredientDetails.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
    }

    private void jTable1KeyPressed(KeyEvent evt) {
    }

    private void isActiveCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void savebtnActionPerformed(ActionEvent evt) {
        this.saveIngredientData();
    }

    private void backbtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComp.setBackground(Color.decode("#f1fbf1"));
            return rendererComp;
        }
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static final DecimalFormat formatter = new DecimalFormat("#.000");

        DecimalFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                try {
                    value = formatter.format((Number)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

