/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.ContextClassLoaderObjectInputStream;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.ObjectResource;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryService
implements RepositoryService {
    private ThreadLocal<RepositoryContext> localContext = new ThreadLocal();

    @Override
    public void setContext(RepositoryContext context) {
        this.localContext.set(context);
        ClassLoader classLoader = (ClassLoader)context.getValue("REPORT_CLASS_LOADER");
        URLStreamHandlerFactory urlHandlerFactory = (URLStreamHandlerFactory)context.getValue("REPORT_URL_HANDLER_FACTORY");
        FileResolver fileResolver = (FileResolver)context.getValue("REPORT_FILE_RESOLVER");
        if (classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(classLoader);
        }
        if (urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(urlHandlerFactory);
        }
        if (fileResolver != null) {
            JRResourcesUtil.setThreadFileResolver(fileResolver);
        }
    }

    @Override
    public void revertContext() {
        RepositoryContext context = this.localContext.get();
        ClassLoader classLoader = (ClassLoader)context.getValue("REPORT_CLASS_LOADER");
        URLStreamHandlerFactory urlHandlerFactory = (URLStreamHandlerFactory)context.getValue("REPORT_URL_HANDLER_FACTORY");
        FileResolver fileResolver = (FileResolver)context.getValue("REPORT_FILE_RESOLVER");
        if (classLoader != null) {
            JRResourcesUtil.resetClassLoader();
        }
        if (urlHandlerFactory != null) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
        if (fileResolver != null) {
            JRResourcesUtil.resetThreadFileResolver();
        }
    }

    @Override
    public InputStream getInputStream(String uri) {
        try {
            URL url = JRResourcesUtil.createURL(uri, null);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
            File file = JRResourcesUtil.resolveFile(uri, null);
            if (file != null) {
                return JRLoader.getInputStream(file);
            }
            url = JRResourcesUtil.findClassLoaderResource(uri, null);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return null;
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException("Not implemented.");
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<? extends Resource> resourceType) {
        if (ReportResource.class.getName().equals(resourceType.getName())) {
            ReportResource resource = null;
            JasperReport report = (JasperReport)this.loadObject(uri);
            if (report != null) {
                resource = new ReportResource();
                resource.setReport(report);
            }
            return (K)resource;
        }
        ObjectResource resource = null;
        Object object = this.loadObject(uri);
        if (object != null) {
            resource = new ObjectResource();
            resource.setValue(object);
        }
        return (K)resource;
    }

    private Object loadObject(String location) {
        Object obj = null;
        InputStream is = this.getInputStream(location);
        if (is != null) {
            ContextClassLoaderObjectInputStream ois = null;
            try {
                ois = new ContextClassLoaderObjectInputStream(is);
                obj = ois.readObject();
            }
            catch (IOException e) {
                throw new JRRuntimeException("Error loading object from : " + location, e);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException("Class not found when loading object from : " + location, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return obj;
    }
}

