/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseDrawer
extends ElementDrawer<JRPrintEllipse> {
    @Override
    public void draw(Graphics2D grx, JRPrintEllipse ellipse, int offsetX, int offsetY) {
        int width = ellipse.getWidth();
        int height = ellipse.getHeight();
        if (ellipse.getModeValue() == ModeEnum.OPAQUE) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, width, height);
        }
        grx.setColor(ellipse.getLinePen().getLineColor());
        Stroke stroke = JRPenUtil.getStroke(ellipse.getLinePen(), 2);
        if (stroke != null) {
            grx.setStroke(stroke);
            AffineTransform oldTx = grx.getTransform();
            if (ellipse.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
                grx.translate((float)(ellipse.getX() + offsetX) - lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) - lineWidth / 3.0f);
                grx.scale(((float)width + 2.0f * lineWidth / 3.0f) / (float)width, ((float)height + 2.0f * lineWidth / 3.0f) / (float)height);
                grx.drawOval(0, 0, width, height);
                grx.setTransform(oldTx);
                grx.translate((float)(ellipse.getX() + offsetX) + lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) + lineWidth / 3.0f);
                if ((float)width > 2.0f * lineWidth / 3.0f) {
                    grx.scale(((float)width - 2.0f * lineWidth / 3.0f) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineWidth / 3.0f) {
                    grx.scale(1.0, ((float)height - 2.0f * lineWidth / 3.0f) / (float)height);
                }
                grx.drawOval(0, 0, width, height);
            } else {
                float lineOffset = BorderOffset.getOffset(ellipse.getLinePen());
                grx.translate((float)(ellipse.getX() + offsetX) + lineOffset, (float)(ellipse.getY() + offsetY) + lineOffset);
                if ((float)width > 2.0f * lineOffset) {
                    grx.scale(((float)width - 2.0f * lineOffset) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineOffset) {
                    grx.scale(1.0, ((float)height - 2.0f * lineOffset) / (float)height);
                }
                grx.drawOval(0, 0, width, height);
            }
            grx.setTransform(oldTx);
        }
    }
}

