/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeVisitor;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import org.krysalis.barcode4j.BaselineAlignment;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;

public class BarcodeVerifier
implements BarcodeVisitor {
    private final JRVerifier verifier;

    public BarcodeVerifier(JRVerifier verifier) {
        this.verifier = verifier;
    }

    protected void verifyBarcode(BarcodeComponent barcode) {
        JRExpression codeExpression = barcode.getCodeExpression();
        if (codeExpression == null) {
            this.verifier.addBrokenRule("Barcode expression is null", (Object)barcode);
        }
        this.verifyTextPosition(barcode);
        this.verifyOrientation(barcode);
        EvaluationTimeEnum evaluationTime = barcode.getEvaluationTimeValue();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            this.verifier.addBrokenRule("Auto evaluation time is not supported for barcodes", (Object)barcode);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = barcode.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                this.verifier.addBrokenRule("No evaluation group set for barcode", (Object)barcode);
            } else if (!this.verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                this.verifier.addBrokenRule("Barcode evalution group \"" + evaluationGroup + " not found", (Object)barcode);
            }
        }
    }

    protected void verifyChecksumMode(String checksumMode, BarcodeComponent barcode) {
        try {
            if (checksumMode != null) {
                ChecksumMode.byName((String)checksumMode);
            }
        }
        catch (Exception e) {
            this.verifier.addBrokenRule(e, (Object)barcode);
        }
    }

    protected void verifyTextPosition(BarcodeComponent barcode) {
        try {
            String position = barcode.getTextPosition();
            if (position != null) {
                HumanReadablePlacement.byName((String)position);
            }
        }
        catch (Exception e) {
            this.verifier.addBrokenRule(e, (Object)barcode);
        }
    }

    protected void verifyOrientation(BarcodeComponent barcode) {
        int orientation = barcode.getOrientation();
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            this.verifier.addBrokenRule("Invalid barcode orientation, supported values are 0, 90, 180, 270", (Object)barcode);
        }
    }

    public void visitCodabar(CodabarComponent codabar) {
        this.verifyBarcode(codabar);
    }

    public void visitCode128(Code128Component code128) {
        this.verifyBarcode(code128);
    }

    public void visitEANCode128(EAN128Component ean128) {
        this.verifyBarcode(ean128);
        this.verifyChecksumMode(ean128.getChecksumMode(), ean128);
    }

    public void visitDataMatrix(DataMatrixComponent dataMatrix) {
        this.verifyBarcode(dataMatrix);
        try {
            String shape = dataMatrix.getShape();
            if (shape != null) {
                SymbolShapeHint.byName((String)shape);
            }
        }
        catch (Exception e) {
            this.verifier.addBrokenRule(e, (Object)dataMatrix);
        }
    }

    public void visitCode39(Code39Component code39) {
        this.verifyBarcode(code39);
        this.verifyChecksumMode(code39.getChecksumMode(), code39);
    }

    public void visitUPCA(UPCAComponent upcA) {
        this.verifyBarcode(upcA);
        this.verifyChecksumMode(upcA.getChecksumMode(), upcA);
    }

    public void visitUPCE(UPCEComponent upcE) {
        this.verifyBarcode(upcE);
        this.verifyChecksumMode(upcE.getChecksumMode(), upcE);
    }

    public void visitEAN13(EAN13Component ean13) {
        this.verifyBarcode(ean13);
        this.verifyChecksumMode(ean13.getChecksumMode(), ean13);
    }

    public void visitEAN8(EAN8Component ean8) {
        this.verifyBarcode(ean8);
        this.verifyChecksumMode(ean8.getChecksumMode(), ean8);
    }

    public void visitInterleaved2Of5(Interleaved2Of5Component interleaved2Of5) {
        this.verifyBarcode(interleaved2Of5);
        this.verifyChecksumMode(interleaved2Of5.getChecksumMode(), interleaved2Of5);
    }

    public void visitRoyalMailCustomer(RoyalMailCustomerComponent royalMailCustomer) {
        this.verifyBarcode(royalMailCustomer);
        this.verifyChecksumMode(royalMailCustomer.getChecksumMode(), royalMailCustomer);
    }

    public void visitUSPSIntelligentMail(USPSIntelligentMailComponent intelligentMail) {
        this.verifyBarcode(intelligentMail);
        this.verifyChecksumMode(intelligentMail.getChecksumMode(), intelligentMail);
    }

    public void visitPostnet(POSTNETComponent postnet) {
        this.verifyBarcode(postnet);
        this.verifyChecksumMode(postnet.getChecksumMode(), postnet);
        if (postnet.getBaselinePosition() != null) {
            try {
                BaselineAlignment.byName((String)postnet.getBaselinePosition());
            }
            catch (Exception e) {
                this.verifier.addBrokenRule(e, (Object)postnet);
            }
        }
    }

    public void visitPDF417(PDF417Component pdf417) {
        this.verifyBarcode(pdf417);
    }
}

